<?php
global $mosConfig_absolute_path;
require_once($mosConfig_absolute_path.'/administrator/components/com_sef/sef.class.php');

class translationJSextensionFilter extends translationFilter
{
    function translationJSextensionFilter ($contentElement){
        $this->filterNullValue = 'all';
        $this->filterType = 'jsextension';
        $this->filterField = $contentElement->getFilter('jsextension');
        parent::translationFilter($contentElement);
    }

    function GetExts() {
        global $database;
        static $exts;

        if( !isset($exts) ) {
            $exts = array();

            $query = "SELECT DISTINCT `extension` FROM `#__sefexttexts`";
            $database->setQuery($query);
            $extensions = $database->loadResultArray();

            if( count($extensions) > 0 ) {
                foreach($extensions as $ext) {
                    $exts[$ext] = SEFTools::getExtName($ext);
                }
            }
        }

        return $exts;
    }

    function _createFilter(){
        global $database;
        if (!$this->filterField ) return "";
        $filter="";
        if ($this->filter_value != $this->filterNullValue){
            $filter = "`extension` = '$this->filter_value'";
        }
        return $filter;
    }


    /**
 * Creates vm_category filter 
 *
 * @param unknown_type $filtertype
 * @param unknown_type $contentElement
 * @return unknown
 */
    function _createfilterHTML(){
        if (!$this->filterField) return "";

        // get list of extensions using texts
        $exts = $this->GetExts();

        $opts = array();
        $opts[] = mosHTML::makeOption( 'all', 'All' );
        if( count($exts) > 0 ) {
            foreach($exts as $ext => $name) {
                $opts[] = mosHTML::makeOption( $ext, $name );
            }
        }

        $list = array();
        $list['title'] = 'Extension:';
        $list['html'] = mosHTML::selectList( $opts, 'jsextension_filter_value', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text', $this->filter_value);

        return $list;

    }

}

?>