<?php
/**
 * SEF component for Joomla! 1.5
 *
 * @author      ARTIO s.r.o.
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     3.1.0
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt
{
    var $params;
    var $metatitle;
    var $metadesc;
    var $metakey;
    var $metakeySource;
    var $nonSefVars;
    var $ignoreVars;
    var $origmetakey;
    var $origmetadesc;
    var $currentUri = '';
    protected $_db=null;
    
    function SefExt()
    {
        // get extension params
        $className = get_class($this);
        if (substr($className, 0, 7) == 'SefExt_') $className = substr($className, 7);    
        $this->params = SEFTools::getExtParams($className);
        $this->_db=JFactory::getDBO();
    }
    
    function setCurrentUri(&$uri)
    {
        $this->currentUri = $uri->toString(array('path', 'query'));
    }

    function beforeCreate(&$uri)
    {
        return;
    }

    function afterCreate(&$uri)
    {
        return;
    }
    
    /**
     * Returns the nonSef vars and ignore vars
     *
     * @param JURI $uri
     * @return array
     */
    function getNonSefVars(&$uri)
    {
        return array(array(), array());
    }

    function getSefUrlFromDatabase(&$uri)
    {
        $db =& JFactory::getDBO();
        $sefConfig =& SEFConfig::getConfig();

        // David (284): ignore Itemid if set to
        $where = '';

        // Get the extension's ignoreSource parameter
        $option = $uri->getVar('option');
        if( !is_null($option) ) {
            $params = SEFTools::getExtParams($option);
            $extIgnore = $params->get('ignoreSource', 2);
        } else {
            $extIgnore = 2;
        }
        $ignoreSource = ($extIgnore == 2 ? $sefConfig->ignoreSource : $extIgnore);
        $Itemid = $uri->getVar('Itemid');
        
        // If Itemid is set as ignored for the component, set ignoreSource to 1
        if (!is_null($Itemid) && !is_null($option)) {
            if (SEFTools::isItemidIgnored($option, $Itemid)) {
                $ignoreSource = 1;
            }
        }
        
        if (!$ignoreSource && !is_null($Itemid)) {
            $where = " AND (`Itemid` = '".$Itemid."' OR `Itemid` IS NULL)";
        }

        $origurl = addslashes(html_entity_decode(urldecode(JoomSEF::_uriToUrl($uri, 'Itemid'))));
        $query = "SELECT * FROM `#__sefurls` WHERE `origurl` = '" . $origurl . "'" . $where . ' LIMIT 2';
        $this->_db->setQuery($query);
        //echo "<b>".str_replace('#__','jos_',$query)."</b><br><br>";
        $sefurls = $this->_db->loadObjectList('Itemid');
        
        if (!$ignoreSource && !is_null($Itemid)) {
            if (isset($sefurls[$Itemid])) {
                $result = $sefurls[$Itemid];
            }
            else if (isset($sefurls[''])) {
                // We've found one of the ignored Itemids, update it with the current and return
                $result = $sefurls[''];
                $result->Itemid = $Itemid;
                $query = "UPDATE `#__sefurls` SET `Itemid` = '{$Itemid}' WHERE `id` = '{$result->id}' LIMIT 1";
                $this->_db->setQuery($query);
                $this->_db->query();
            }
            else {
                $result = reset($sefurls);
            }
        }
        else {
            $result = reset($sefurls);
        }
            
        return is_object($result) ? $result : false;
    }

    function create(&$uri)
    {
        $vars = $uri->getQuery(true);
        extract($vars);
        
        $title = array();
        $title[] = JoomSEF::_getMenuTitleLang(@$option, $lang, @$Itemid);

        $newUri = $uri;
        if (count($title) > 0) {
            $newUri = JoomSEF::_sefGetLocation($uri, $title, null, null, null, @$lang);
        }
        
        return $newUri;
    }
    
    function revert($route, &$disabled)
    {
        $sefConfig =& SEFConfig::getConfig();
        $cache =& SEFCache::getInstance();
        $vars = array();

        $route = html_entity_decode(urldecode($route));
        $routeNoSlash = rtrim($route, '/');
        
        // try to use cache
        if ($sefConfig->useCache) {
            $row = $cache->getNonSefUrl($route);
        }
        else $row = null;

        // cache worked
        if ($row) $fromCache = true;
        else {
            // URL isn't in cache or cache disabled
            $fromCache = false;
            
            if ($sefConfig->transitSlash) {
                $where = "(`sefurl` = ".$this->_db->Quote($routeNoSlash).") OR (`sefurl` = ".$this->_db->Quote($routeNoSlash.'/').")";
            } else {
                $where = "`sefurl` = ".$this->_db->Quote($route);
            }
            $sql = "SELECT * FROM #__sefurls WHERE ($where) AND (`origurl` != '') ORDER BY `priority` LIMIT 1	";
            $this->_db->setQuery($sql);
            $row = $this->_db->loadObject();
        }

        if ($row) {
            // Set the disabled flag (old cache records don't need to have enabled set)
            if (!isset($row->enabled)) {
                $row->enabled = 1;
            }
            if ($row->enabled) {
                $disabled = false;
            } else {
                $disabled = true;
            }
            
            // Use the already created URL
            $string = $row->origurl;
            if (isset($row->Itemid) && ($row->Itemid != '')) {
                $string .= (strpos($string, '?') ? '&' : '?') . 'Itemid=' . $row->Itemid;
            }

            // update the hits count if needed
            if (!$fromCache || $sefConfig->cacheRecordHits) {
                $where = '';
                if (!empty($row->id)) {
                    $where = " WHERE `id` = '{$row->id}'";
                } else {
                    $where = " WHERE `sefurl` = '{$row->sefurl}' AND `origurl` != ''";
                }
            
                $this->_db->setQuery("UPDATE #__sefurls SET cpt=(cpt+1)".$where);
                $this->_db->query();
            }
            
            $string = str_replace( '&amp;', '&', $string );
            $QUERY_STRING = str_replace('index.php?', '', $string);
            parse_str($QUERY_STRING, $vars);
            
            // Moved to JoomSEF::_parseSefUrl()
            /*
            if ($sefConfig->setQueryString) {
                $_SERVER['QUERY_STRING'] = $QUERY_STRING;
            }
            */

            // prepare the meta tags array for MetaBot
            // only if URL is not disabled
            if (!$disabled) {
                $mainframe =& JFactory::getApplication();
                if (!empty($row->metatitle))  $mainframe->set('sef.meta.title',  $row->metatitle);
                if (!empty($row->metadesc))   $mainframe->set('sef.meta.desc',   $row->metadesc);
                if (!empty($row->metakey))    $mainframe->set('sef.meta.key',    $row->metakey);
                if (!empty($row->metalang))   $mainframe->set('sef.meta.lang',   $row->metalang);
                if (!empty($row->metarobots)) $mainframe->set('sef.meta.robots', $row->metarobots);
                if (!empty($row->metagoogle)) $mainframe->set('sef.meta.google', $row->metagoogle);
                if (!empty($row->canonicallink)) $mainframe->set('sef.link.canonical', $row->canonicallink);
                if(!empty($row->metaauthor)) {
                	$mainframe->set('sef.meta.author',$row->metaauthor);
                }
                if (isset($row->showsitename))   $mainframe->set('sef.meta.showsitename', $row->showsitename);
            }

            // If cache is enabled but URL isn't in cache yet, add it
            if ($sefConfig->useCache && !$fromCache) {
                $cache->addUrl($row->origurl, $row->sefurl, $row->cpt + 1, $row->Itemid, $row->metatitle, $row->metadesc, $row->metakey, $row->metalang, $row->metarobots, $row->metagoogle, $row->metaauthor, $row->canonicallink, $row->enabled, $row->sef);
            }
        } elseif ($sefConfig->useMoved) {
            // URL not found, let's try the Moved Permanently table
            $where = '';
            if( $sefConfig->transitSlash ) {
                $where = "(`old` = '{$routeNoSlash}') OR (`old` = '{$routeNoSlash}/')";
            }
            else {
                $where = "`old` = '{$route}'";
            }
            $this->_db->setQuery("SELECT * FROM `#__sefmoved` WHERE {$where}");
            $row = $this->_db->loadObject();

            if($row) {
                // URL found, let's update the lastHit in table and redirect
                $this->_db->setQuery("UPDATE `#__sefmoved` SET `lastHit` = NOW() WHERE `id` = '$row->id'");
                $this->_db->query();

                $root = JURI::root();
                $f = $l = '';
                if (!headers_sent($f, $l)) {
                    // Let's build absolute URL from our link
                    if( strstr($row->new, $root) === false ) {
                        $url = $root;
                        if (substr($url, -1) != '/') $url .= '/';
                        if (substr($row->new, 0, 1) == '/') $row->new = substr($row->new, 1);
                        $url .= $row->new;
                    } else {
                        $url = $row->new;
                    }

                    // Use the link to redirect
                    header('HTTP/1.1 301 Moved Permanently');
                    header('Location: ' . $url);
                    header('Connection: close');
                    exit();
                } else {
                    JoomSEF::_headers_sent_error($f, $l, __FILE__, __LINE__);
                }
            }
        }

        return $vars;
    }

    /**
     * Get metatags.
     * If they do not exist, generate new.
     * 
     * @return array
     */
    function getMetaTags()
    {
        $sefConfig = SEFConfig::getConfig();
        
        // clean source of meta description
        if (!empty($this->metadesc)) $cleanDesc = SEFTools::cleanDesc($this->metadesc);
        else $cleanDesc = '';
        // clean source of meta keywords
        if (!empty($this->metakeySource)) $cleanKeySource = SEFTools::cleanDesc($this->metakeySource);
        else $cleanKeySource = $cleanDesc;
        
        // generate own meta description if set to by extension and global configuration
        if ($this->params->get('meta_desc', '1') && ($sefConfig->metadata_auto == _COM_SEF_META_GEN_ALWAYS || $sefConfig->metadata_auto == _COM_SEF_META_GEN_EMPTY && strlen($this->origmetadesc) == 0)) {            
        	// get generation params 
            $maxLen = $this->params->get('desc_len', '250');
            // generate description
            $this->metatags['metadesc'] = SEFTools::clipDesc($cleanDesc, $maxLen);
        } else /*if($sefConfig->metadata_auto == _COM_SEF_META_GEN_EMPTY && strlen($this->origmetadesc))*/ {
        	$this->metatags['metadesc']=$this->origmetadesc;
        }
        
        // generate own meta keywords if set to by extension and global configuration
        if ($this->params->get('meta_keys', '1') 
            && ($sefConfig->metadata_auto == _COM_SEF_META_GEN_ALWAYS 
                || $sefConfig->metadata_auto == _COM_SEF_META_GEN_EMPTY && strlen($this->origmetakey) == 0)) {
            // get generation params
            $minLen = $this->params->get('keys_minlen', '3');
            $count = $this->params->get('keys_count', '8');
            $blacklist = $this->params->get('blacklist', null);
            // generate keywords
            $this->metatags['metakey'] = SEFTools::generateKeywords($cleanKeySource, $blacklist, $count, $minLen);
        } else /*if($sefConfig->metadata_auto == _COM_SEF_META_GEN_EMPTY && strlen($this->origmetakey)) */ {
        	$this->metatags['metakey']=$this->origmetakey;
        }
        return $this->metatags;
    }

    /**
     * Returns sitemap parameters for given URI
     */
    function getSitemapParams(&$uri)
    {
        return array();
    }

    /**
     * Uses the extension's create() method to generate the meta tags for given URI.
     * Extensions should override this function with more efficient and sophisticated algorithm.
     * 
     * @param $uri URI to generate meta tags for
     * @return array Associative array of meta tags
     */
    function generateMeta(&$uri)
    {
        $data = $this->create($uri);
        
        if (is_object($data) && is_a($data, 'JURI')) {
            // Backwards compatibility
            return array();
        }
        else {
            if (isset($data['metadata']) && is_array($data['metadata'])) {
                return $data['metadata'];
            }
            else {
                return array();
            }
        }
    }
    
    protected function getMetaData($row) {
    	$this->metatags=array();
    	if(isset($row->metakey)) {
    		$this->metatags["metakey"]=$row->metakey;
    	}
    	if(isset($row->metadesc)) {
    		$this->metatags["metadesc"]=$row->metadesc;
    	}
    	if(isset($row->metadata)) {
    		$metadata=new JParameter($row->metadata);
			$this->metatags["metaauthor"]=$metadata->get('author');
			$this->metatags["metarobots"]=$metadata->get('robots');
    	}
    	$this->lang=$row->language;
    }
    
    function getParam($name) {
    	return $this->params->get($name);
    }
    
    protected function getCategoryInfo($id)
    {
        $sefConfig =& SEFConfig::getConfig();
        $jfTranslate = $sefConfig->translateNames ? ', `id`' : '';

    	$field = 'title';
        if (SEFTools::UseAlias($this->params, 'category_alias')) {
            $field = 'alias';
        }

        $addId = (bool) $this->params->get('categoryid', '0');

        $path = array();
        $id = intval($id);
        $this->_db->setQuery("SELECT `lft`, `rgt` FROM `#__categories` WHERE `id` = '{$id}'");
        $idx = $this->_db->loadObject();
        if (!$idx) {
        	return false;
        }

		$query="SELECT `title`, `alias`, `description`, language, `metakey`, `metadesc`, `metadata`, `parent_id`{$jfTranslate} FROM `#__categories` WHERE `lft` <= '{$idx->lft}' AND `rgt` >= '{$idx->rgt}' AND id!=1 ORDER BY `lft` DESC";
		if($this->params->get('show_category',2)==1) {
			$query.=" LIMIT 1";
		}
        $this->_db->setQuery($query);
        $cats = $this->_db->loadObjectList();
        $result = null;
        $this->metatags=array();

        foreach ($cats as $cat) {
        	// Get only last category metas
            if (is_null($result)) {
                $result = new stdClass();
                $this->lang=$cat->language;
                $this->metadesc=$cat->description;
                $this->metatags["metakey"]=$cat->metakey;
                $this->metatags["metadesc"]=$cat->metadesc;
                
				$metadata=new JParameter($cat->metadata);
				$this->metatags["metaauthor"]=$metadata->get('author');
				$this->metatags["metarobots"]=$metadata->get('robots');
				
				$this->metadesc=$cat->description;
				$this->origmetadesc=$cat->metadesc;
				$this->metakeysource=$cat->description;
				$this->origmetakey=$cat->metakey;
				                
            }

        	$name = ($addId ? $id.'-'.$cat->$field : $cat->$field);
        	array_unshift($path, $name);
        	if (empty($this->metatags["metadesc"])) {
        		$this->metatags["metadesc"]=$cat->description;
        	}
        	$id = $cat->parent_id;

        	if ($id <= 1) {
        		break;
        	}
        }

        if (is_null($result)) {
            $result = new stdClass();
        }
        $this->path = $path;
        
        
        return $path;
    }
}

/**
 * JoomSEF basic rewriting class
 *
 */
class SefExt_Basic extends SefExt
{
    function _addValue(&$title, $value)
    {
        if (!is_array($value)) {
            $title[] = $value;
        }
        else {
            foreach ($value as $val) {
                $this->_addValue($title, $val);
            }
        }
    }
    
    function create(&$uri)
    {
        $vars = $uri->getQuery(true);
        extract($vars);
        
        $title = array();
        
        if ($this->params->get('showMenuTitle', '1') == '1') {
            $title[] = JoomSEF::_getMenuTitleLang($uri->getVar('option'), @$lang, $uri->getVar('Itemid'));
        }
        else {
            $title[] = substr($uri->getVar('option'), 4);
        }
        
        $noAdd = array('option', 'lang', 'Itemid');
        foreach($vars as $name => $value) {
            if (in_array($name, $noAdd)) {
                continue;
            }
            
            // Arrays support
            $this->_addValue($title, $value);
        }

        $newUri = $uri;
        if (count($title) > 0) {
            $newUri = JoomSEF::_sefGetLocation($uri, $title, null, null, null, @$lang);
        }
        
        return $newUri;
    }
}

?>