<?php
/**
 * ReMOSitory SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     $Name$, ($Revision: 4994 $, $Date: 2005-11-03 20:50:05 +0100 (??t, 03 XI 2005) $)
 */

// Security check to ensure this file is being included by a parent file.
if (!defined('_VALID_MOS')) die('Direct Access to this location is not allowed.');

class sefext_com_events extends sef_joomsef
{
    var $params;

    // Returns category name
    function GetCategoryName($id)
    {
        global $database, $sefConfig;

        $jfTranslate = ($sefConfig->translateNames ? ', `id`' : '');
        $query = "SELECT `name`$jfTranslate FROM `#__categories` WHERE `id` = '$id' LIMIT 1";
        $database->setQuery($query);
        $obj = null;
        $database->loadObject($obj);

        return (isset($obj->name) ? $obj->name : '');
    }

    // Returns event name
    function GetEventName($id)
    {
        global $database, $sefConfig;

        $jfTranslate = ($sefConfig->translateNames ? ', `id`' : '');
        $query = "SELECT `title`$jfTranslate FROM `#__events` WHERE `id` = '$id' LIMIT 1";
        $database->setQuery($query);
        $obj = null;
        $database->loadObject($obj);

        return (isset($obj->title) ? $obj->title : '');
    }

    function AddToDate($value, &$date) {
        // Appends or prepends the value according to params
        if( ($this->params->get('dateFormat', '1') == '1') ) {
            // Append value (yyyy-mm-dd)
            array_push($date, $value);
        } else {
            // Prepend value (dd-mm-yyyy)
            array_unshift($date, $value);
        }
    }

    // Alters the URL before SEF
    function beforeCreate($string, &$vars) {
        if( isset($vars['catids']) ) {
            // Let's remove catids variable if it's set for multiple categories
            // (there is either one, or all of them - all of them is the same
            //  as if catids isn't present, causing duplicities)
            if( strpos($vars['catids'], '|') !== false ) {
                $string = SEFTools::RemoveVariable($string, 'catids');
            }
            
            // Also if task is view_cat, rename catids to catid (don't know why
            // they're creating it with catids, when that URL doesn't work anyway)            
            else if( isset($vars['task']) && ($vars['task'] == 'view_cat') ) {
                $string = str_replace('catids=', 'catid=', $string);
            }
        }

        return $string;
    }

    function create($string, &$vars) {
        // Load the texts to use in URL
        $texts = SEFTools::getExtTexts('com_events');
        $this->params = SEFTools::getExtParams('com_events');

        // Extract variables
        extract($vars);
        $title = array();

        $title[] = getMenuTitle(@$option, @$task, @$Itemid);

        // Thanks to our beforeCreate function, catids always contains only one ID
        if( isset($catids) ) {
            $title[] = $this->GetCategoryName($catids);
        } else if( isset($catid) ) {
            $title[] = $this->GetCategoryName($catid);
        }

        // Date handling
        // -------------------------
        $datum = array();
        
        // Add year
        if( isset($year) ) {
            $this->AddToDate($year, $datum);
        }

        // Add month
        if( isset($month) ) {
            $this->AddToDate($month, $datum);
        }

        // Add day
        if( isset($day) ) {
            $this->AddToDate($day, $datum);
        }

        // Create date
        if( count($datum) > 0 ) {
            $title[] = join('-', $datum);
        }
        // -------------------------

        // Add event name
        if( isset($agid) ) {
            $title[] = $this->GetEventName($agid);
        }

        // Add task
        if( isset($task) ) {
            if( in_array($task, array_keys($texts)) ) {
                $title[] = $texts[$task];
                unset($task);
            } else if( in_array($task, array('view_day', 'view_detail')) ) {
                unset($task);
            }
        }

        // Save the URL in database
        if (count($title) > 0) {
            $nonSefVars = array();
            if( isset($limitstart) )    $nonSefVars['limitstart'] = $limitstart;
            if( isset($limit) )         $nonSefVars['limit'] = $limit;
            if( isset($keyword) )       $nonSefVars['keyword'] = $keyword;
            if( isset($push) )          $nonSefVars['push'] = $push;
            if( isset($pop) )           $nonSefVars['pop'] = $pop;

            $string = sef_joomsef::sefGetLocation($string, $title, @$task, @$limit, @$limitstart, @$lang, $nonSefVars);
        }

        return $string;
    }
}