<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   1.0.4
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2015 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

// Load required classes
require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/classes/helper.php');

class VmsmsOrderChecker
{
    public static function checkOrders()
    {
        // Only run if VM1 is installed
        if (!VmsmsHelper::isVm1()) {
            return;
        }
        
        // Check if there are any orders which status changed
        $db = JFactory::getDBO();
        $q = "SELECT `o`.`order_id` AS `virtuemart_order_id`, `o`.`user_id` AS `virtuemart_user_id`, `o`.`order_total`, `o`.`order_status`, `os`.`last_status`"
            ." FROM `#__vm_orders` AS `o`"
            ." LEFT JOIN `#__vmsms_order_status` AS `os` ON (`os`.`vm_order_id` = `o`.`order_id`)"
            ." WHERE (`os`.`last_status` IS NULL) OR (`o`.`order_status` != `os`.`last_status`)";
        $db->setQuery($q);
        $orders = $db->loadObjectList();
        
        // Are there any updated orders?
        if (!is_array($orders) || (count($orders) == 0)) {
            // No orders
            return;
        }
        
        // Load our vmshipment plugin
        JPluginHelper::importPlugin('vmshipment', 'vmsms');
        $dispatcher = JDispatcher::getInstance();
        
        // Loop through orders and run our SMS plugin for them
        foreach ($orders as $order) {
            // Update the record in our table with the new status
            $q = "REPLACE INTO `#__vmsms_order_status` (`vm_order_id`, `last_status`)"
                ."  VALUES (".(int)$order->virtuemart_order_id.", ".$db->quote($order->order_status).")";
            $db->setQuery($q);
            $db->query();
            
            // Set order number according to VM function
            $order->order_number = sprintf('%08d', $order->virtuemart_order_id);
            
            // Trigger the event
            $dispatcher->trigger('plgVmOnUpdateOrderShipment', array(&$order, $order->last_status));
        }
    }
}
