<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   1.0.4
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2015 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

// Load required classes
require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/classes/helper.php');

if (!class_exists('vmPSPlugin')) {
    if (VmsmsHelper::isVm2()) {
        require(JPATH_VM_PLUGINS.'/vmpsplugin.php');
    }
    else {
        class vmPSPlugin extends JPlugin
        { }
    }
}

/**
 * Use a vmshipment plugin instead of vmpayment, so we can be sure
 * that all the vmpayment plugins were successful
 */
class plgVmShipmentVmsms extends vmPSPlugin
{
    public function __construct(&$subject, $config)
    {
        parent::__construct($subject, $config);
    }
    
    public function plgVmOnUpdateOrderShipment(&$data, $old_order_status)
    {
        $newStatus = $data->order_status;
        $orderNum = $data->order_number;
        $total = number_format($data->order_total, 2);
        $userId = intval($data->virtuemart_user_id);
        $orderId = intval($data->virtuemart_order_id);
        $deliveryDate = isset($data->delivery_date) ? $data->delivery_date : '';
        
        // Check if status changed
        if ($newStatus == $old_order_status) {
            return true;
        }
        
        // Get status ID
        $db = JFactory::getDbo();
        $state = null;
        if (VmsmsHelper::isVm1()) {
            $db->setQuery("SELECT `order_status_id` FROM `#__vm_order_status` WHERE `order_status_code` = ".$db->quote($newStatus));
            $state = $db->loadResult();
        }
        else if (VmsmsHelper::isVm2()) {
            $db->setQuery("SELECT `virtuemart_orderstate_id` FROM `#__virtuemart_orderstates` WHERE `order_status_code` = ".$db->quote($newStatus));
            $state = $db->loadResult();
        }
        if (!$state) {
            return true;
        }
        
        // Load required VM SMS classes
        require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/classes/config.php');
        require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/lib/httphelper.php');
        require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/lib/smsservice.php');
        
        // Get config for current state
        $config = VmsmsConfig::getInstance();
        $sendUser = $config->getSendUser($state);
        $sendCustomer = $config->getSendCustomer($state);
        
        if (!$sendUser && !$sendCustomer) {
            // Don't send anything
            return true;
        }
        
        // Load user info
        $user = null;
        if ($userId > 0) {
            $user = JFactory::getUser($userId);
        }
        $sms = AVmsmsSmsService::getInstance();
        
        $customerName = $this->getUsername($orderId);
        
        if ($sendUser) {
            // Send SMS to owner
            $text = $config->getUserText($state);
            $text = $this->replacePlaceholders($text, $orderNum, $total, $customerName, $deliveryDate);
            $sms->sendOwnMessage($config->username, $config->apiKey, $text, $config->allowUnicode, 'vmsms1');
        }
        
        if ($sendCustomer) {
            // Get customer phone number
            $phone = $this->getPhoneNumber($orderId);
            if (!empty($phone)) {
                // Get customer language
                $lang = null;
                if (is_object($user)) {
                    $lang = $user->getParam('language');
                }
                if (empty($lang)) {
                    // Get default website language
                    $params = JComponentHelper::getParams('com_languages');
                    $lang = $params->get('site', 'en-GB');
                }
                
                // Send SMS to customer
                $text = $config->getCustomerText($state, $lang);
                $text = $this->replacePlaceholders($text, $orderNum, $total, $customerName, $deliveryDate);
                $sms->sendMessage($config->username, $config->apiKey, $phone, $text, $config->allowUnicode, 'vmsms1');
            }
        }
        
        return true;
    }
    
    private function getUsername($orderId)
    {
        $db = JFactory::getDbo();
        
        $names = null;
        if (VmsmsHelper::isVm1()) {
            $query = "SELECT `address_type`, `first_name`, `middle_name`, `last_name` FROM `#__vm_order_user_info` WHERE `order_id` = ".(int)$orderId;
            $db->setQuery($query);
        }
        else if (VmsmsHelper::isVm2()) {
            $query = "SELECT `address_type`, `first_name`, `middle_name`, `last_name` FROM `#__virtuemart_order_userinfos` WHERE `virtuemart_order_id` = ".(int)$orderId;
            $db->setQuery($query);
        }
        $names = $db->loadObjectList('address_type');
        
        $name = null;
        if (isset($names['ST'])) {
            $name = $names['ST'];
        }
        else if (isset($names['BT'])) {
            $name = $names['BT'];
        }
        else {
            // No name
            return '';
        }
        
        $parts = array();
        if (!empty($name->first_name)) {
            $parts[] = $name->first_name;
        }
        if (!empty($name->middle_name)) {
            $parts[] = $name->middle_name;
        }
        if (!empty($name->last_name)) {
            $parts[] = $name->last_name;
        }
        
        return implode(' ', $parts);
    }
    
    private function getPhoneNumber($orderId)
    {
        $config = VmsmsConfig::getInstance();
        $db = JFactory::getDbo();
        
        $primary = $config->primary_phone;
        $secondary = $config->secondary_phone;
        
        $phones = null;
        if (VmsmsHelper::isVm1()) {
            $query = "SELECT `address_type`, `{$primary}` AS `phone1`, `{$secondary}` AS `phone2` FROM `#__vm_order_user_info` WHERE `order_id` = ".(int)$orderId;
            $db->setQuery($query);
        }
        else if (VmsmsHelper::isVm2()) {
            $query = "SELECT `address_type`, `{$primary}` AS `phone1`, `{$secondary}` AS `phone2` FROM `#__virtuemart_order_userinfos` WHERE `virtuemart_order_id` = ".(int)$orderId;
            $db->setQuery($query);
        }
        $phones = $db->loadObjectList('address_type');
        
        // Prepare array of phone numbers according to priority
        $numbers = array();
        if (isset($phones['ST'])) {
            $numbers[] = $phones['ST']->phone1;
            $numbers[] = $phones['ST']->phone2;
        }
        if (isset($phones['BT'])) {
            $numbers[] = $phones['BT']->phone1;
            $numbers[] = $phones['BT']->phone2;
        }
        
        foreach ($numbers as $phone) {
            if (!empty($phone)) {
                $phone = $this->checkPhone($phone);
                if (is_string($phone)) {
                    return $phone;
                }
            }
        }
        
        return false;
    }
    
    /**
     * Applies the phone numbers rules to given phone number.
     * Returns valid phone number or false if it doesn't pass the filters.
     */
    private function checkPhone($phone)
    {
        $config = VmsmsConfig::getInstance();
        
        // Remove spaces and leading plus and zeroes
        $phone = str_replace(' ', '', $phone);
        $phone = ltrim($phone, '+0');
        
        // Add country code if needed
        if (strlen($phone) <= $config->localCountryMinDigits) {
            $phone = $config->localCountry['dial_code'].$phone;
        }
        
        // Check include filters
        foreach ($config->includeNumbers as $dial => $filters) {
            // Try to find the filters for this dial code
            if (strpos($phone, (string)$dial) === 0) {
                // Get number without the dial code
                $number = substr($phone, strlen($dial));
                
                // Check patterns - at least one must be passed
                $passed = false;
                foreach ($filters['filters'] as $pattern) {
                    if ($this->checkPattern($number, $pattern)) {
                        $passed = true;
                        break;
                    }
                }
                if (!$passed) {
                    // Number didn't pass
                    return false;
                }
                break;
            }
        }
        
        // Check exclude filters
        foreach ($config->excludeNumbers as $dial => $filters) {
            // Try to find the filters for this dial code
            if (strpos($phone, (string)$dial) === 0) {
                // Get number without the dial code
                $number = substr($phone, strlen($dial));
                
                // Check patterns - none of them can pass
                foreach ($filters['filters'] as $pattern) {
                    if ($this->checkPattern($number, $pattern)) {
                        // Number is excluded
                        return false;
                    }
                }
                break;
            }
        }
        
        // Phone number can be used
        return $phone;
    }
    
    /**
     * Checks if given phone number (without the country dial code!) matches given pattern
     */
    private function checkPattern($number, $pattern)
    {
        if (strpos($pattern, '-') !== false) {
            // Range
            $range = explode('-', $pattern);
            $min = $range[0];
            $max = $range[1];
            
            if ($this->checkPatternOp($number, $min, 'min') && $this->checkPatternOp($number, $max, 'max')) {
                return true;
            }
        }
        else {
            if ($this->checkPatternOp($number, $pattern, 'exact')) {
                return true;
            }
        }
        
        return false;
    }
    
    /**
     * Checks if given number passes given pattern with given operation.
     * $op can be: min, max, exact
     */
    private function checkPatternOp($number, $pattern, $op)
    {
        $pattern = str_split($pattern);
        $number = str_split($number);
        
        $count = count($pattern);
        $maxNum = count($number);
        for ($i = 0; $i < $count; $i++) {
            $pchar = $pattern[$i];
            
            // Check for asterisk
            if ($pchar == '*') {
                // Asterisk can be only last in the pattern and matches anything
                return true;
            }
            
            // Check length
            if ($i >= $maxNum) {
                // Pattern is longer than number, didn't pass
                return false;
            }
            
            // Check question mark
            if ($pchar == '?') {
                // Matches anything, continue
                continue;
            }
            
            // Check number according to specified operation
            $nchar = $number[$i];
            if (!is_numeric($nchar)) {
                // We can match only numeric symbols now
                return false;
            }
            
            $pnum = intval($pchar);
            $nnum = intval($nchar);
            if ($op == 'exact') {
                if ($pnum != $nnum) {
                    // Didn't pass
                    return false;
                }
            }
            else if ($op == 'min') {
                // Number must be >= pattern
                if ($nnum < $pnum) {
                    // Didn't pass
                    return false;
                }
            }
            else if ($op == 'max') {
                // Number must be <= pattern
                if ($nnum > $pnum) {
                    // Didn't pass
                    return false;
                }
            }
            else {
                // Unknown operation, fail
                return false;
            }
        }
        
        // Passed
        return true;
    }
    
    private function replacePlaceholders($text, $orderNum, $orderTotal, $username, $deliveryDate)
    {
        $placeholders = array('%customer%', '%order_nr%', '%order_total%', '%delivery_date%');
        $replace = array($username, $orderNum, $orderTotal, $deliveryDate);
        
        return str_replace($placeholders, $replace, $text);
    }
}
